<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Facades\Auth;
use DB;

/**
 * Hilco\Models\WebLink
 *
 * @property integer $id
 * @property integer $web_link_category_id
 * @property string $links
 * @property string $type
 * @property string $date_modified
 * @property string $deleted_at
 */
class WebLink extends WebModel {
    protected $table = "WebLinks";
    protected $fillable = ['user_visibility', 'link','type','order','display_name','webSiloIds','web_link_category_id'];
    public static $userVisibility = ['Hidden', 'Visible For All', 'For Anonymous User', 'For Logged In User'];
    public static $types =[
        'landing_page' => 'Landing Page',
        'general' => 'Any URL',
    ];
    public static $typeValues = [
        'landing_page',
        'asset',
        'general',
    ];

    public function webLinkWebSiloJoins() {
        return $this->hasMany(WebLink_WebSilo::class, 'weblink_id', 'id');
    }

    public function category() {
        return $this->belongsTo(WebLinkCategory::class, 'web_link_category_id');
    }

    public function getUrl(){
        if ($this->type == 'landing_page') {
            $url = route('landingpage.slug', [$this->link]);
        } else if ($this->type == 'asset') {
            $url = config('hilco.assets.url');
            $url .= '/' . $this->link;
        } else {
            $url = url($this->link);
        }

        return $url;
    }

    public function scopeAvailableForUser($query){
        $user = Auth::user();
        if(isset($user)){
            $query = $query->where(function($query){
                return $query->where('WebLinks.user_visibility',1)->orWhere('WebLinks.user_visibility',3);
            });
        }else{
            $query = $query->where(function($query){
                return $query->where('WebLinks.user_visibility',1)->orWhere('WebLinks.user_visibility',2);
            });
        }
        $webSilo = b2b()->activeWebSilo();
        $query->whereHas('webLinkWebSiloJoins', function ($query) use ($webSilo) {
            return $query
                ->where('websilo_id', '=', $webSilo->id)
                ->where('WebLink_WebSilo.is_visible', '=', 1)
            ;
        });

        return $query;
    }

    public function getDisplayNameAttribute() {
        $translatedName = $this->getTranslation('name');
        if (!strlen($translatedName)) $translatedName = $this->attributes['display_name'];
        return $translatedName;
    }

    public function getDisplayNameForUACAttribute() {
        return $this->getDisplayNameAttribute();
    }
    use HasModelTranslations;

}
