<?php
namespace Hilco\Models;

use DB;

class DatafeedJob extends WebModel {
    protected $table = 'DatafeedJobs';
    
    public function datafeed() {
        return $this->belongsTo(Datafeed::class);
    }

    public function isOverdue()
    {
        $datafeed = $this->datafeed;
        return ($this->findNextRun() < now());
    }

    public function findNextRun() {
        $now = Carbon::now();
        $submit_time = new Carbon($this->submit_time);
        // Not overdue if we are before the datafeed's start date
        if ($now < $this->datafeed->firstStartTime()) return null;
        // Not overdue if we are after the datafeed's end date
        if ($now > $this->datafeed->lastStartTime()) return null;

        if ($this->datafeed->autorun_cadence == 'daily') {
            $date = $this->datafeed->firstStartTime();
            for ($date; $date <= $this->datafeed->lastStartTime(); $date = $date->addDay()) {
                if ($date > $submit_time) {
                    return $date;
                }
            }
        } else if ($this->datafeed->autorun_cadence == 'weekly') {
            $date = $this->datafeed->firstStartTime();
            for ($date; $date <= $this->datafeed->lastStartTime(); $date = $date->addWeek($this->datafeed->autorun_weekly_frequency)->startOfWeek(Carbon::MONDAY)) {
                $checkdate = $date->copy();
                // Start of week wipes out the hour and minute, so put those back in for the date we care about
                $checkdate->hour($this->datafeed->autorun_hour);
                $checkdate->minute($this->datafeed->autorun_minute);
                
                // Progress through the whole week (Starting on Monday) checking appropriate days
                foreach(array(CARBON::MONDAY, CARBON::TUESDAY, CARBON::WEDNESDAY, CARBON::THURSDAY, CARBON::FRIDAY, CARBON::SATURDAY, CARBON::SUNDAY) as $dayOfWeek) {
                    // The only reason this if check is necessary is because the outer loop might not start on a Monday
                    if ($checkdate->dayOfWeek == $dayOfWeek) {
                        if ($this->datafeed->hasWeeklyWeekday($dayOfWeek)) {
                            // If this day is greater than our submit time, this is the next time we are supposed to run
                            if ($checkdate > $submit_time) {
                                return $checkdate;
                            }
                        }
                        //increment the date so that we check the remaining days of the week
                        $checkdate = $checkdate->addDay(1);
                    }
                }
            }
            // If we made it this far, there are no more valid runs before end_date is reached
            return null;
        } else if($this->datafeed->autorun_cadence == 'monthly') {

        } else if($this->datafeed->autorun_cadence == 'yearly') {

        }
        return null;
        Carbon::now()->startOfWeek(Carbon::MONDAY)->weekday(Carbon\Carbon::SUNDAY);
    }
}
