<?php
/**
 * Created by PhpStorm.
 * User: developer
 * Date: 8/15/16
 * Time: 12:42 PM
 */

namespace Hilco\Models;


class SalesOrderLineSchedule extends WebModel
{
    protected $table = 'Import_SalesOrderLineSchedules';

    public static $statuses = [
        "CANCELED",
        "OPEN",
        "PAID",
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     * @deprecated Phase this out, importSalesOrder() is the correct relationship to use
     */
    public function order()
    {
        return $this->belongsTo(Order::class, 'salesorder_id');
    }

    public function importSalesOrder() {
        return $this->belongsTo(Import_SalesOrder::class, 'importsalesorder_id');
    }

    public function importSalesOrderLine() {
        return $this->belongsTo(Import_SalesOrderLine::class, 'importsalesorderline_id');
    }

    public function shipment() {
        return $this->belongsTo(Shipment::class, 'shipment_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     * @deprecated Phase this out, importSalesOrderLine() is the correct relationship to use
     */
    public function orderMainLine()
    {
        return $this->belongsTo(OrderMainLine::class, 'salesordermainline_id');
    }

    public function scopeWithStatus($query, $status=[], $method="in"){
        $whereStatuses = array_intersect(self::$statuses,$status);
        if($method=="in") return $query->whereIn('schedule_status',$whereStatuses);
        elseif($method=="notIn") return $query->whereNotIn('schedule_status',$whereStatuses);
        else return $query;
    }
}