<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Hilco\Models\StagedOneOffLineDiscount
 * @property integer id
 * @property integer stagedorderdiscline_id
 * @property string discount_factor
 * @property float discountfactor_value
 * @property string discount_code
 * @property string discount_desc
 * @property float discount_amount
 * @property float discount_percent
 * @property bool is_manual_discount
 * @property mixed vwlinediscount_id
 * @property StagedOrderDiscLine stagedOrderDiscLine
 * @property VWLineDiscount vwLineDiscount
 */
class StagedOneOffLineDiscount extends StagingModel {
    protected $table = "StagedOneOffLineDiscounts";

    /**
     * @return float
     */
    public function getDiscountAmount(): float {
        return $this->discount_amount;
    }

    /**
     * @return string
     */
    public function getDiscountCode(): string {
        return $this->discount_code;
    }

    /**
     * @return string
     */
    public function getDiscountDesc(): string {
        return $this->discount_desc;
    }

    /**
     * @return string|null
     */
    public function getDiscountFactor(): ?string {
        return $this->discount_factor;
    }

    /**
     * @return float|null
     */
    public function getDiscountFactorValue(): ?float {
        return $this->discountfactor_value;
    }

    /**
     * @return float
     */
    public function getDiscountPercent(): float {
        return $this->discount_percent;
    }

    /**
     * @return bool
     */
    public function isManualDiscount(): bool {
        return $this->is_manual_discount;
    }

    /**
     * @return BelongsTo
     */
    public function stagedOrderDiscLine(): BelongsTo {
        return $this->belongsTo(StagedOrderDiscLine::class, "stagedorderdiscline_id", "id");
    }

    /**
     * @return BelongsTo
     */
    public function vwLineDiscount(): BelongsTo {
        return $this->belongsTo(VWLineDiscount::class, "vwlinediscount_id", "id");
    }
}