@if($edit)
    <div class="mceNonEditable component-container" data-component-key="micrositeChildren"
         data-children-title="{{ $title }}"
         data-children-type="{{ $type }}"
         data-children-layout="{{ $layout }}"
    >
<a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('hilco::app.microsite_children')</h4>
        <p>@lang('hilco::app.displays_children_of_the_current_microsite')</p>
        <div>
            @lang('hilco::app.title_colon') <div style="display: inline;" class="microsite-children-title"> {{ $title }} </div><br>
            @lang('hilco::app.type_colon') <div style="display: inline;" class="microsite-children-type"> {{ Arr::get($types, $type) }}</div><br>
            @lang('hilco::app.layout_colon') <div style="display: inline;" class="microsite-children-layout"> {{ Arr::get($layouts, $layout) }}</div><br>
        </div>
        <a href="#" class="microsite-children-settings-button btn btn-primary">@lang('hilco::app.configure')</a>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('micrositeChildren', {
            menuText: '@lang('hilco::app.microsite_children')',
            bladeTemplate: 'hilco::components.micrositeChildren',
            init: function (body) {
                $(body).on('click', 'a.microsite-children-settings-button', function () {
                    var component = $(this).closest('.component-container');
                    var data = {
                        title: $(component).data('children-title'),
                        type: $(component).data('children-type'),
                        layout: $(component).data('children-layout'),
                    };
                    var types = {!! json_encode($types) !!};
                    var layouts = {!! json_encode($layouts) !!};

                    function buildList(list, data) {
                        var items = [];
                        $.each(list, function (key, value) {
                            items.push({
                                text: value,
                                value: key,
                                selected: data.layout == key,
                            });
                        });
                        return items;
                    }

                    win = tinymce.activeEditor.windowManager.open({
                        title: '@lang('hilco::app.configure_container_children')',
                        data: data,
                        body: [
                            {
                                name: 'title',
                                type: 'textbox',
                                label: '@lang('hilco::app.title')',
                                values: buildList(types, data),
                            },
                            {
                                name: 'type',
                                type: 'listbox',
                                label: '@lang('hilco::app.type')',
                                values: buildList(types, data),
                            },
                            {
                                name: 'layout',
                                type: 'listbox',
                                label: '@lang('hilco::app.layout')',
                                values: buildList(layouts, data),
                            },
                        ],
                        onSubmit: function (e) {
                            data = tinymce.extend(data, e.data);
                            component
                                .data('children-title', data.title)
                                .data('children-type', data.type)
                                .data('children-layout', data.layout)
                                .attr('children-title', data.title)
                                .attr('data-children-type', data.type)
                                .attr('data-children-layout', data.layout)
                            ;
                            component.find('.microsite-children-title').text(data.title);
                            component.find('.microsite-children-type').text(types[data.type]);
                            component.find('.microsite-children-layout').text(layouts[data.layout]);
                        }
                    })
                });
            },
            serialize: function (componentNode) {
                return {
                    title: $(componentNode).data('children-title'),
                    type: $(componentNode).data('children-type'),
                    layout: $(componentNode).data('children-layout'),
                };
            },
        });
    </script>
@endif

@if($view)
    @if(b2b()->activeWebSilo()->$type->count())
        <div class="row container center-block">
            <div class="col-md-12">
                <div class="panel panel-primary">
                    <div class="panel-heading">
                        <h3 class="panel-title text-center">{{ $title or ''}}</h3>
                    </div>
                    <div class="panel-body" style="height: 240px">
                        <div id="microsite-children-carousel" class="owl-carousel owl-theme">
                            @foreach (b2b()->activeWebSilo()->$type as $child)
                                <div class="microsite-child-item" style="display: none;">
                                    <a href="{{$child->slugUrl(true)}}" class="">
                                        <div class="image" style="min-height: 100px; padding-top: 15px">
                                            <img src="{{ $child->primaryImage(325, 125) }}" class="img img-responsive center-block" style="max-height: 150px">
                                        </div>
                                        <div class="caption text-center">
                                            <h5>{{ $child->name }}</h5>
                                        </div>
                                    </a>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <script type="text/javascript">
            $(document).ready(function() {
                var micrositeChildrenCarousel = $('#microsite-children-carousel');
                micrositeChildrenCarousel.on({
                    'initialized.owl.carousel': function() {
                        micrositeChildrenCarousel.find('.microsite-child-item').show();
                    }
                }).owlCarousel({
                    autoplay: true,
                    autoplayTimeout: 3500,
                    autoplayHoverPause: true,
//                    loop: true,
                    responsive: {
                        0: {
                            items: 1,
                        },
                        320: {
                            items: 1
                        },
                        480: {
                            items: @if(auth()->user()) 2 @else 2 @endif,
                        },
                        768: {
                            items: @if(auth()->user()) 3 @else 3 @endif,
                        },
                        992: {
                            items: @if(auth()->user()) 3 @else 3 @endif,
                        },
                        1440: {
                            items: @if(auth()->user()) 4 @else 4 @endif,
                        },
                    },
                });
            });
        </script>
    @endif
@endif
