<?php

namespace Hilco\Models;

use Arr;

class SubscriptionItem extends UuidModel {
    protected $table = 'SubscriptionItems';
    protected $fillable = [
        'id',
        'subscriptiongroup_id',
        'createdby_webuser_id',
        'lastmodifiedby_webuser_id',
        'part_id',
        'quantity',
        'comment',
        'last_calculated_price',
        'out_of_stock_event_sent',
        'discontinued_event_sent',
    ];

    public function subscriptionGroup() {
        return $this->hasOne(SubscriptionGroup::class, 'id', 'subscriptiongroup_id');
    }

    public function createdByWebUser() {
        return $this->hasOne(WebUser::class, 'id', 'createdby_webuser_id');
    }
    public function modifiedByWebUser() {
        return $this->hasOne(WebUser::class, 'id', 'modifiedby_webuser_id');
    }

    public function part() {
        return $this->hasOne(Part::class, 'id', 'part_id');
    }

    public function getBaseItemKlaviyoArray(): array {
        $part = $this->part;
        $webPart = $part->webPart;
        $webFamily = is_null($webPart) ? null : $webPart->webFamily;
        return [
            'ProductID' => $part->part_no,
            'ProductName' => $part->part_desc,
            'Quantity' => $this->quantity,
            'ProductURL' => route('family.slug', [Arr::get($webFamily, 'slug', ''), Arr::get($webPart, 'id', '')]),
            'SmallImageURL' => WebAsset::urlHelper(['key' => Arr::get($part, 'part_no', ''), 'prefix' => 'pn', 'width' => 150, 'height' => 150]),
            'ImageURL' => WebAsset::urlHelper(['key' => Arr::get($part, 'part_no', ''), 'prefix' => 'pn']),
        ];
    }

    public function getBaseItemWithPricesKlaviyoArray ($itemPrice, $rowTotal): array {
        $baseItemArr = $this->getBaseItemKlaviyoArray();
        $baseItemArr['ItemPrice'] = b2b()->formatPrice($itemPrice);
        $baseItemArr['RowTotal'] = b2b()->formatPrice($rowTotal);
        return $baseItemArr;
    }
}