@if($edit)
    <div class="mceNonEditable component-container" data-component-key="bannerCarousel">
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('hilco::app.banner_carousel')</h4>
        <p>@lang('hilco::app.display_banners_across_the_entire_width_of_the_page_that_rotate')</p>
        <div data-banner-id="{{ $bannerId }}" class="banner-container">
            <div class="row slides-container">
                @foreach ($slides as $slideId => $slide)
                    <div class="col-md-3 view-full-container" data-slide-id="{{$slideId}}">
                        @include('hilco::components.targetCustomer.viewSelector', ['alternateViews' => Arr::get($slide, 'alternateViews', [])])
                        @include('hilco::components.bannerCarouselSlide',
                        [
                            'slide' => $slide,
                            'visibleDates' => Arr::get($slide, 'visibleDates', []),
                            'visibleDatesFormatted' => Arr::get($slide, 'visibleDatesFormatted', 'All'),
                            'slideId' => 0,
                            'default' => true
                        ])
                        @foreach(Arr::get($slide, 'alternateViews', []) as $altSlideId => $altSlide)
                            @include('hilco::components.bannerCarouselSlide',
                                array_merge($altSlide,
                                    [
                                        'slideId' => $altSlideId,
                                        'default' => false
                                    ])
                            )
                        @endforeach
                    </div>
                @endforeach
            </div>
            <div class="row">
                <div class="col-md-4 col-md-offset-4">
                    <a href="#" class="btn btn-primary add-slide-button">@lang('hilco::app.add_slide')</a>
                </div>
            </div>

            </div>
        </div>
@endif

@if($script)
<script type="text/javascript">

registerComponent('bannerCarousel', {
menuText: '@lang('hilco::app.banner_carousel')',
bladeTemplate: 'hilco::components.bannerCarousel',
init: function (body) {
    initViewFunctions(body);

    $(body).on('click', 'a.add-slide-button', function() {
        var banner = $(this).closest('.banner-container');
        var lastSlide = $(banner).find('div.view-full-container').last();
        var newSlideId = lastSlide.data('slide-id') + 1;
        var newSlide = lastSlide.clone();
        newSlide.attr('data-slide-id', newSlideId);
        newSlide.find('div.slide-container.alternate').remove();
        newSlide.find('a.alt-view').closest('li').remove();
        newSlide.find('[data-slide-id]').each(function () {
            $(this).attr('data-slide-id', newSlideId);
        }).find('img').attr('src', '');

        //in case the default slide is hidden and the tab is inactive, show and activate them
        newSlide.find('div.slide-container.default').removeClass('hidden').addClass('visible');
        newSlide.find('ul.visibility-controls>li').first().addClass('active');

        $(banner).find('.slides-container').append(newSlide);
    });
    $(body).on('click', 'a.delete-slide-button', function () {
        var slide = $(this).closest('.view-full-container');
        var slideCount = $(this).closest('.banner-container').find('.view-full-container').length;
        if (slideCount == 1) {
            alert('@lang('hilco::app.you_cannot_delete_the_last_slide')');
            return;
        }

        $(slide).remove();
    });
    $(body).on('click', '.slide-thumbnail', function () {
        var slide = $(this).closest('.slide-container');
        assets.finder({
            successFunction: function (data) {
                var alt;
                if(data.alttag != null && data.alttag != ""){
                    alt = data.alttag;
                }else if(data.name != null && data.name != ""){
                    alt = data.name;
                }else{
                    alt = 'None'
                }

                $(slide).attr('data-web-asset-id', data.id).find('.slide-thumbnail').attr('src', data.urls.thumbnailByHeight);
                if(alt != 'None') {
                    $(slide).attr('data-web-asset-id', data.id).find('.slide-thumbnail').attr('alt', alt);
                    $(slide).attr('data-img-alttag', alt);
                }
                $(slide).attr('data-web-asset-id', data.id).find('.slide-alttag').text(alt);
            }
        });
    });
    $(body).on('click', '.slide-url', function () {
        var slide = $(this).closest('.slide-container');
        assets.link({
            successFunction: function (link) {
                $(slide)
                    .attr('data-link-type', link.link_type)
                    .attr('data-link-target', link.target)
                    .find('.slide-url').text(link.description);
                ;
            }
        });
    });
    $(body).on('click', '.slide-alttag', function () {
        var slide = $(this).closest('.slide-container');
        assets.description({
            successFunction: function (data) {
                if(data.alttag != null && data.alttag != ""){
                    $(slide).attr('data-img-alttag', data.alttag);
                    $(slide).find('.slide-alttag').text(data.alttag);
                    $(slide).attr('data-web-asset-id', data.id).find('.slide-thumbnail').attr('alt', data.alttag);
                }
            }
        });
    });
},
serialize: function (componentNode) {
    var data = {
        slides: [],
    };
    $(componentNode).find('.slide-container.default').each(function () {
        var alternateViews = {};
        $(this).closest('.view-full-container').find('.view-container.alternate').each(function () {
            var targetCustomers = {};
            try{
                targetCustomers = JSON.parse($(this).attr('data-target-customers'));
            }catch (e){
                //use the empty object
            }
            var visibleDates = {};
            try{
                visibleDates = JSON.parse($(this).attr('data-visible-dates'));
            }catch (e){
                //use the empty object
            }
            alternateViews[$(this).attr('data-view-id')] = {
                slide: {
                    webAssetId: $(this).data('web-asset-id'),
                    alttag: $(this).data('img-alttag'),
                    link: {
                        type: $(this).data('link-type'),
                        target: $(this).data('link-target'),
                    }
                },
                targetCustomers: targetCustomers,
                targetCustomersFormatted: $(this).find('.view-targetcustomers').text(),
                visibleDates: visibleDates,
                visibleDatesFormatted: $(this).find('.view-visibledates').text()
            }
        });
        var visibleDates = {};
        try{
            visibleDates = JSON.parse($(this).attr('data-visible-dates'));
        }catch (e){
            //use the empty object
        }
        data.slides.push({
            webAssetId: $(this).data('web-asset-id'),
            alttag: $(this).data('img-alttag'),
            link: {
                type: $(this).data('link-type'),
                target: $(this).data('link-target'),
            },
            defaultVisibility: $(this).attr('data-default-visibility').trim(),
            visibleDates: visibleDates,
            visibleDatesFormatted: $(this).find('.view-visibledates').text(),
            alternateViews: alternateViews
        });
    });
    return data;
},
});
</script>
@endif

@if($view && b2b()->allowBannerCarousel($lpModel))
@php $bannerId = str_random(8); @endphp
<div id="banner-carousel-{{$bannerId}}" class="owl-carousel owl-theme">
@foreach($slides as $slide)
    @include('hilco::components.targetCustomer.viewRenderer', ['blade' => 'hilco::components.bannerCarouselSlide', 'bladeViewArgs' => ['slide' => $slide], 'alternateViews' => Arr::get($slide, 'alternateViews', []), 'defaultVisibility' => Arr::get($slide, 'defaultVisibility', 'Visible'), 'visibleDates' => Arr::get($slide, 'visibleDates', []), 'view' => $slide])
@endforeach
</div>
<script type="text/javascript">
$(document).ready(function () {
$('#banner-carousel-{{$bannerId}}').owlCarousel({
    center: true,
    items: 1,
    @if(count($slides) > 1)
        loop: true,
    @endif
    autoplay: true,
    autoplayTimeout: {{ isset($bannerTimeout) ? $bannerTimeout : '3500' }},
    autoplayHoverPause: true,
    dots: true,
    smartSpeed: 1250,
    onInitialized: loadOwlCarouselDotDescs,
    onResized: loadOwlCarouselDotDescs,
});
});
</script>
@endif