<?php
/**
 * Created by PhpStorm.
 * User: ntaylor-visionware
 * Date: 4/6/18
 * Time: 12:01 PM
 */

namespace Hilco\Models;


class PromotionCodeTrigger extends PromotionTriggerDetails {

    protected $table = 'PromotionCodeTriggers';
    protected $fillable = ['code'];

    public function promotion() {
        return $this->morphToMany(Promotion::class, 'trigger',
            'PromotionTriggers', 'trigger_id', 'promotion_id');
    }

    public function isTriggered(Customer $soldToCustomer, $webCartItems, $distinctPartInfo = []) {
        $activePromoCodes = b2b()->activePromoCodes();
        if($activePromoCodes != null){
            foreach($activePromoCodes as $activePromoCode){
                if($this->code === $activePromoCode){
                    return true;
                }
            }
        }

        return false;
    }

    public function postTriggerOperation($soldToCustomer) {
        // TODO: Implement postTriggerOperation() method.
    }
}