<?php

namespace Hilco\Models;

use Illuminate\Support\Collection;

class PriceListCustomer extends WebModel
{
    protected $table = 'CustomerPriceLists';

    public function scopePriceGroup($query, $group) {
        return $query->where('sales_code', '=', $group)->where('sales_type', '=', 'Customer Price Group');
    }

    public function scopeCustomer($query, $customer) {
        return $query->where('sales_code', '=', $customer)->where('sales_type', '=', 'Customer');
    }

    public function scopeAllCustomers($query) {
        return $query->where('sales_type', '=', 'All Customers');
    }

    public function scopeForCustomerOrGroup($query, $customer, $group) {
        if (is_null($customer)) $customer = '';
        if (is_null($group)) $group = '';
        return $query
            ->where('sales_type', '=', 'All Customers')
            ->orWhere(function ($where) use ($customer) {
                return $where
                    ->where('sales_type', '=', 'Customer')
                    ->where('sales_code', '=', $customer)
                ;
            })
            ->orWhere(function ($where) use ($group) {
                return $where
                    ->where('sales_type', '=', 'Customer Price Group')
                    ->where('sales_code', '=', $group)
                    ;
            })
        ;
    }

    public function scopeActive($query) {
        return $query
            ->whereRaw('start_date <= DATE(NOW())')
            ->where(function ($wheres) {
                return $wheres
                    ->whereRaw('end_date >= DATE(NOW())')
                    ->orWhere('end_date', '=', '1753-01-01')
                ;
            })
        ;
    }
}
