<?php

namespace Hilco\Models;

/**
 * Hilco\Models\CustomerPharmacyInfos
 *
 * @property integer $id
 * @property integer $customer_id
 * @property string $address_number
 * @property string $license_number
 * @property string $npi_number
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 *
 */
class CustomerPharmacyInfos extends UuidModel {
	protected $table = 'CustomerPharmacyInfos';

	public function customer()
	{
		return $this->belongsTo(Customer::class, 'customer_id');
	}

	public function scopeIsRX($query){
		$query->where('npi_number','!=',"''")->where('npi_number','!=',"N/A");
	}

	public function checkRx(){
		return (isset($this->npi_number) && $this->npi_number != '' && $this->npi_number !='N/A');
	}

}
