@if($edit)
    <div class="mceNonEditable component-container" data-component-key="userInfo">
    <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>User Dashboard</h4>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('userInfo', {
            menuText: 'User Dashboard',
            bladeTemplate: 'hilco::components.userInfo',
            init: function (body) {

            },
            serialize: function (componentNode) {
                return {};
            },
        });
    </script>
@endif

@if($view)
    @if(canUser('b2b-orders'))
        <div class="row container center-block">
            <div class="col-xs-12">
                @if (!rewards()->isRegistered())
                    @if(rewards()->isEligible())
                        @include('hilco::components.rewards.notSignedUp')
                        <br>
                    @endif
                @else
                    @include('hilco::components.rewards.member')
                @endif
            </div>
        </div>
    <div class="row container center-block">
        <div class="col-md-4">
            <div class="panel panel-default"  style="height: 300px;">
                <div class="panel-heading">
                    <h3 class="panel-title">
                        <a href="{{ route('orders.list') }}" class="pull-right">See All</a>
                        Recent Orders
                    </h3>
                </div>
                <div class="panel-body" style="height: 260px; overflow-y: auto;">
                    @foreach(b2b()->activeCustomer()->recentOrders(4)->groupBy('order_date') as $orderDate => $orders)
                        <div class="row">
                            <div class="col-md-12 h4 nomargin">
                                {{ date('D, M j Y', strtotime($orderDate)) }}
                            </div>
                        </div>
                        @foreach($orders as $order)
                            <div class="row">
                                <div class="col-md-12">
                                    <div style="padding-left: 10px">
                                        <a href="{{ route('orders.details', [$order->hilco_order_number]) }}">{{ $order->hilco_order_number }}</a>
                                        ({{ $order->friendly_order_status }}) - {{ $order->total_quantity }} {{ str_plural('item', $order->total_quantity) }},
                                        {{ $order->total_shipped }} shipped
                                    </div>
                                </div>
                            </div>
                        @endforeach
                        <hr style="margin: 5px;">
                    @endforeach
                </div>
            </div>
        </div>
        <div class="col-md-8">
            <div class="panel panel-default"  style="height: 300px;">
            <div class="panel-heading">
                    <h3 class="panel-title">
                        <a href="{{ route('orders.reorder') }}" class="pull-right">See All</a>
                        Reorder Frequently Ordered Items
                    </h3>
                </div>
                <div class="panel-body">
                    <div id="favorites-carousel" class="owl-carousel owl-theme">
                        @foreach(b2b()->activeCustomer()->topPurchasedItems() as $family)
                            @include('partials.family-block', ['family' => $family, 'captionClass' => 'h4', 'containerStyle' => 'display: none;'])
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
    @if(\Route::has('orders.orderHistoryDataTable'))
    <script type="text/javascript">
            $(document).ready(function () {
                var favoriteItemsCarousel = $('#favorites-carousel');
                favoriteItemsCarousel.on({
                    'initialized.owl.carousel': function() {
                        favoriteItemsCarousel.find('.family-block-item').show();
                    }
                }).owlCarousel({
                    autoplay: true,
                    autoplayTimeout: 5000,
                    loop: true,
                    responsive: {
                        0: {
                            items: 1,
                        },
                        320: {
                            items: 1
                        },
                        480: {
                            items: 1,
                        },
                        768: {
                            items: 2,
                        },
                        992: {
                            items: 2,
                        },
                        1440: {
                            items: 2,
                        },
                    },
                });
            });
        </script>
    @endif
    @endif
@endif
