<?php

namespace Hilco\Models;

/**
 * Hilco\Models\ProductFamily
 *
 * @property mixed $id
 * @property string $product_family_no
 * @property mixed $productcategory_id
 * @property mixed $financialreportgroup_id
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read \Hilco\Models\Product $part
 * @property-read ProductCategory $productCategory
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductFamily whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductFamily whereProductFamilyNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductFamily whereProductcategoryId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductFamily whereFinancialreportgroupId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductFamily whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductFamily whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductFamily whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $date_uploaded
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductFamily whereDateUploaded($value)
 */
class ProductFamily extends UuidModel
{
	protected $table = 'ProductFamilies';

	/**
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function part()
	{
		return $this->belongsTo(Part::class, 'id', 'productfamily_id');
	}

	public function productCategory() {
	    return $this->belongsTo(ProductCategory::class, 'productcategory_id');
    }

    public function parts() {
	    return $this->hasMany(Part::class, 'productfamily_id', 'id');
    }

    public function getProductFamilyNo() {
        return $this->product_family_no;
    }
}
