<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use LogicException;

class PromotionItemDiscountAction extends PromotionActionDetails
{
    protected $table = 'PromotionItemDiscountActions';
    protected $fillable = ['quantity_to_discount', 'discount_percent', 'discount_entire_order', 'discount_note', 'commit_sequence'];

    public function promotion() {
        return $this->morphToMany(Promotion::class, 'action', 'PromotionActions', 'promotion_id', 'promotionitemdiscountaction_id');
    }

    public function webGroups() {
        return $this
            ->morphedByMany(WebGroup::class, 'product', 'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
        ;
    }

    public function webCategories() {
        return $this
            ->morphedByMany(WebCategory::class, 'product', 'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
        ;
    }

    public function webCollections() {
        return $this
            ->morphedByMany(WebCollection::class, 'product', 'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
        ;
    }

    public function webFamilies() {
        return $this
            ->morphedByMany(WebFamily::class, 'product', 'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
        ;
    }

    public function webParts() {
        return $this
            ->morphedByMany(WebPart::class, 'product', 'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
            ;
    }

    public function getRelationForProductTableType($tableType) {
        //
        if($tableType === 'webFamily' || $tableType === 'webCategory') {
            $relationName = substr($tableType, 0, -1);
            $relationName .= 'ies';
        }
        else {
            $relationName = $tableType . 's';
        }
        return $this->$relationName();
    }

    public function isApplicable(Part $part) {        
        if ($this->discount_entire_order) return true;

        $validGroup = $validCategory = $validCollection = $validFamily = $validPart = false;

        $validWebGroupIds = $this->webGroups->pluck('id')->toArray();
        $validWebCategoryIds = $this->webCategories->pluck('id')->toArray();
        $validWebCollectionIds = $this->webCollections->pluck('id')->toArray();
        $validWebFamilyIds = $this->webFamilies->pluck('id')->toArray();
        $validWebPartIds = $this->webParts->pluck('id')->toArray();

        $webPart = array_get($part, 'webPart');
        if (count($validWebPartIds) < 1 || in_array($webPart->id, $validWebPartIds)) $validPart = true;

        $webFamily = array_get($webPart, 'webFamily');
        if (count($validWebFamilyIds) < 1 || in_array($webFamily->id, $validWebFamilyIds)) $validFamily = true;

        foreach (array_get($webFamily, 'webCollections', []) as $webCollection) {
            if (count($validWebCollectionIds)) {
                if (in_array($webCollection->id, $validWebCollectionIds)) $validCollection = true;
            } else $validCollection = true;

            foreach (array_get($webCollection, 'webCategories', []) as $webCategory) {
                if (count($validWebCategoryIds)) {
                    if (in_array($webCategory->id, $validWebCategoryIds)) $validCategory = true;
                } else $validCategory = true;

                foreach (array_get($webCategory, 'webGroups', []) as $webGroup) {
                    if (count($validWebGroupIds)) {
                        if (in_array($webGroup->id, $validWebGroupIds)) $validGroup = true;
                    } else $validGroup = true;
                }
            }
        }

        return $validGroup && $validCategory && $validCollection && $validFamily && $validPart;
    }

    public function takeAction(Customer $soldToCustomer, $webCartItems, &$status)
    {
        // TODO: Implement takeAction() method.
        if($this->discount_entire_order){
            foreach($status['items'] as $item) {
                $discountPercent = $this->discountPercent;
                $discountAmount = round($item['basePrice'] * ($discountPercent / 100), 2);
                $extendedDiscountAmount = $discountAmount * $item['quantity'];
                $baseDiscountAmount = round($item['basePrice'] * ($discountPercent / 100), 2);
                $discountedPrice = $item['basePrice'] - $baseDiscountAmount;
                $extendedPrice = $discountedPrice * $item['quantity'];

            }
        } else {
        }
    }
}
