<?php

namespace Hilco\Models;

use Auth;
use DB;
use Illuminate\Database\Eloquent\Model;

class WebCart extends WebModel
{
    protected $table = 'WebCarts';
    protected $fillable = ['quantity'];

    public function webPart() {
        return $this->hasOne(WebPart::class, 'part_number', 'part_number');
    }

    public function webUser() {
        return $this->hasOne(WebUser::class, 'webuser_id', 'id');
    }

    public function priceList() {
//        return $this->hasOne(PriceList::class)
    }

    public function scopeForUser($query, $webuserId) {
        return $query->where('webuser_id', $webuserId);
    }

    public function scopePartNumber($query, $partNumber) {
        return $query->where('part_number', $partNumber);
    }

//    public function product() {
//        return $this->belongsTo(Product::class);
//    }

    public function getExtendedPriceAttribute() {
        return $this->webPart->getCustomerPrice($this->quantity) * $this->quantity;
    }

    public static function add(WebPart $webPart, $quantity = 1)
    {
        $instance = new static;
        $instance->webuser_id = Auth::id();
        $instance->part_number = $webPart->part_number;
        $instance->quantity = $quantity;
        $instance->save();
        return $instance;
    }

    public static function remove($userId, $partNumber)
    {
        $instance = new static;
        return $instance::where(['part_number' => $partNumber, 'webuser_id' => $userId])->delete();
    }

    public static function cartItems($webUserId = false, $billToCustomerSegmentId = false) {
        // Get the web user. If and ID is provided, use it, otherwise, use who ever is logged in.
        if ($webUserId === false)
            $webUser = auth()->user();
        else
            $webUser = WebUser::find($webUserId);
        if (is_null($webUser)) return [];

        // Get the sold to customer.
        $soldToCustomer = $webUser->active_customer;

        // Get the bill to customer. If an ID is provided, us it, otherwise, use the sold to customer.
        if ($billToCustomerSegmentId === false) {
            $billToCustomerSegment = $soldToCustomer->activeSegment;
        } else {
            $billToCustomerSegment = CustomerSegment::find($billToCustomerSegmentId);
        }
        if (is_null($billToCustomerSegment)) return [];

        // Get the two price lists. First is the price lsit for the bill to customer, the second is the default for the silo (Catalog most likely)
        $customerPriceList = $billToCustomerSegment->def_price_list;
        $siloPriceList = WebSilo::currentPriceList();

        // Get all of the cart items for the user.
        $cartItems = self::forUser($webUser->id)->with(['webPart' => function ($query) use ($webUser) {
            return $query->with([
                'part' => function ($query) use ($webUser) {
                    $query->with(['prices' => function ($query) use ($webUser) {
                        $query
                            ->where('currency', $webUser->currency)
                            ->where('price_list', $webUser->default_price_list)
    //                        ->whereRaw('PriceLists.quantity_level >= WebCarts.quantity')
                        ;
                    }]);
                },
                'promos' => function ($query){
                   return $query->with('rules');
                },
            ])->with('webFamily');
        }])->get();

        // Loop through all of the items a get a count for each.
        // Because the same item can have multiple entries, we need a sum for each part id.
        $totalPromoQuantity = 0;
        $partsByPrice = [];
        $priceListQuantityArray = [];
        foreach ($cartItems as $cartItem) {
            if (isset($priceListQuantityArray[$cartItem->webPart->id])) {
                $priceListQuantityArray[$cartItem->webPart->id] += $cartItem->quantity;
            } else {
                $priceListQuantityArray[$cartItem->webPart->id] = $cartItem->quantity;
            }

            // At this time we do a quick calculation for the Jonathan Paul promotion.
            foreach($cartItem->webPart->webFamily->webCollections as $collection) {
                if ($collection->id == config("hilco.jpPromoCollectionId") && !in_array($cartItem->webPart->webFamily->id, explode('^', config('hilco.jpPromoIgnoreId')))) {
                    $totalPromoQuantity += $cartItem->quantity;
                    $partsByPrice[''.$cartItem->webPart->getCustomerPrice($cartItem->quantity)][$cartItem->id] = $cartItem->quantity;
                    break;
                }
            }
        }

        // Loop through each part again and calculate the prices...
        foreach ($cartItems as $key => $cartItem) {
            if (isset($priceListQuantityArray[$cartItem->webPart->id])) {
                $part = $cartItem->webPart->part;

                // First we need the total quantity calculated above.
                $cartItems[$key]->priceListQuantity = $priceListQuantityArray[$cartItem->webPart->id];

                // Next we use the total quantity to find the correct price list given the part, bill to price list, currency, and quantity.
                $priceList = PriceList::where('currency', WebUser::activeCurrency())->where('price_list', '=', $customerPriceList)->where('part_id', '=', $part->id)->where('quantity_level', '<=', $priceListQuantityArray[$cartItem->webPart->id])->orderBy('quantity_level', 'DESC')->first();
                // If no price list exists, we do the same thing, but with the silo's default price list.
                if ($priceList == null) {
                    $priceList = PriceList::where('currency', WebUser::activeCurrency())->where('price_list', '=', $siloPriceList)->where('part_id', '=', $part->id)->where('quantity_level', '<=', $priceListQuantityArray[$cartItem->webPart->id])->orderBy('quantity_level', 'DESC')->first();
                }

                if ($priceList !== null) {
                    $cartItems[$key]->priceListPrice = $priceList->price;
                    $cartItems[$key]->unconvertedPrice = $priceList->price;
                } else {
                    // If we still don't have a price list, we use the price in the part table.
                    $cartItems[$key]->unconvertedPrice = $part->list_price;
                    if (WebUser::activeCurrency() === 'USD') {
                        $cartItems[$key]->priceListPrice = $part->list_price;
                    } else {
                        // If the customer does not use USD, then we need to convert to their price.
                        $rate = CurrencyRate::where('year', '<=', 2017)->where('month', '<=', 3)->where('USD', '>', 0)->where(WebUser::activeCurrency(), '>', 0)->where('deleted_at', '=', '0000-00-00 00:00:00')->orderBy('year', 'DESC')->orderBy('month', 'DESC')->value(WebUser::activeCurrency());
                        if ($rate != null && $rate > 0) {
                            $cartItems[$key]->priceListPrice = round($part->list_price * $rate, 2);
                        } else {
                            $cartItems[$key]->priceListPrice = $part->list_price;
                        }
                    }
                }

                $cartItems[$key]->contract_flag = $priceList !== null && $priceList->contract_flag;
                $cartItems[$key]->discountedPrice = $cartItems[$key]->priceListPrice;

                // If the price list doesn't have the contract flag set, calculate discounts.
                if (!$cartItems[$key]->contract_flag) {
                    $customerDiscounts = CustomerDiscount::where('customer_id', '=', $soldToCustomer->id)
                        ->where(function ($query) use ($part) {
                            $query->where('productfamily_id', '=', $part->productfamily_id);
                            $query->orWhere('part_id', '=', $part->id);
                        })
                        ->where('deleted_at', '=', DB::raw('0'))
                        ->get();

                    if ($customerDiscounts !== null) {
                        foreach ($customerDiscounts as $customerDiscount) {
                            $cartItems[$key]->discountedPrice -= round($cartItems[$key]->priceListPrice  * ($customerDiscount->disc_val / 100), 2);
                        }
                    }
                }

                // Set the final price.
                $cartItems[$key]->calculatedPrice = $cartItems[$key]->discountedPrice * $cartItems[$key]->quantity;
            }
        }

        // Promo stuff.
        if ($totalPromoQuantity > 12) {
            ksort($partsByPrice, SORT_NUMERIC);

            $discountedFrameCount = $totalPromoQuantity > 13 ? 2 : 1;

            $freeWebCartIds = [];
            foreach ($partsByPrice as $price => $webCartIds) {
                foreach ($webCartIds as $webCartId=>$quantity) {
                    $freeWebCartIds[$webCartId] = min($discountedFrameCount, $quantity);
                    $discountedFrameCount -= $freeWebCartIds[$webCartId];

                    if ($discountedFrameCount <= 0) break;
                }
                if ($discountedFrameCount <= 0) break;
            }

            foreach ($cartItems as $key=>$cartItem) {
                if(isset($freeWebCartIds[$cartItem->id])) {
                    $cartItems[$key]->promo_quantity = $freeWebCartIds[$cartItem->id];
                    $cartItems[$key]->promoPrice = $cartItems[$key]->discountedPrice * ($cartItems[$key]->quantity - $cartItems[$key]->promo_quantity);
                }
            }
        }

        return $cartItems;
    }
    
    public static function getCartDiscount(){
        return rulesChecker::checkPromoRules(app('generalPromos'));
    }
    
}
