<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Venturecraft\Revisionable\RevisionableTrait;

/**
 * Class WebHierarchy
 * @package Hilco\Models
 * @property int $id
 * @property string $name
 * @property bool $is_default
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property int $commit_sequence
 */
class WebHierarchy extends WebModel {
	protected $table = "WebHierarchies";
    protected $fillable = [
        'name',
        'is_default',
    ];
	protected $casts = [
	    'is_default' => 'boolean'
	];

	public function webGroups() {
		return $this->belongsToMany(WebGroup::class, 'WebGroup_WebHierarchy', 'webhierarchy_id', 'webgroup_id')->wherePivot('deleted_at', '=', '0000-00-00 00:00:00')->withPivot('display_order');
	}

	public function webSilos() {
	    return $this->hasMany(WebSilo::class, 'webhierarchy_id', 'id');
    }

    public function webGroupsForLayout() {
	    return $this
            ->webGroups()
            ->isVisible()
            ->where('WebGroups.is_menubar', '1')
            ->hasVisibleChildren()
//            ->alphabetical()
            ->displayOrder()
            ->with([
                'translations',
                'webSiloOverride.webProductMenuConfiguration',
                'webProductMenuConfiguration',
                'webCategories' => function ($query) {
                    return $query
                        ->isVisible()
                        ->hasVisibleChildren()
                        ->alphabetical()
                        ->with([
                            'translations',
                            'webSiloOverride',
                            'webCollections' => function ($query) {
                                return $query
                                    ->isVisible()
                                    ->hasVisibleChildren()
                                    ->alphabetical()
                                    ->with(['translations'])
                                ;
                            }
                        ])
                    ;
                }
            ])
        ;
    }

    public function scopeHasVisibleChildren(Builder $query, $activeWebSilo = false, $activeCountry = false, $activePlant = false) {
	    return $query
            ->whereHas('webGroups', function ($query) use ($activeWebSilo, $activeCountry, $activePlant) {
                return $query->hasVisibleChildren($activeWebSilo, $activeCountry, $activePlant);
            })
        ;
    }

    public function scopeHasVisibleParents(Builder $query, $activeWebSilo = false) {
	    return $query
            ->whereHas('webSilos', function ($query) use ($activeWebSilo) {
                return $query->isActiveWebSilo($activeWebSilo);
            })
        ;
    }

    public function scopeHasSolrVisibleParents(Builder $query) {
        return $query
            ->whereHas('webSilos', function ($query) {
                return $query->where('is_visible', '1');
            })
            ;
    }

}
