<?php

namespace Hilco\Models;

use DB;
use Hilco\Models\SelectsRelatedCount;
use Venturecraft\Revisionable\RevisionableTrait;

class WebAttribute extends WebModel
{
	protected $table = 'WebAttributes';
	protected $fillable = ['attribute_name'];

	public function webParts() {
		return $this->belongsToMany(WebPart::class, 'WebAttribute_WebPart', 'webattribute_id', 'webpart_id')->withPivot(['attribute_value']);
	}

	public function webFamilies() {
		return $this->belongsToMany(WebFamily::class, 'WebAttribute_WebFamily', 'webattribute_id', 'webfamily_id');
	}

	public function values() {
		return $this->hasMany(WebAttribute_WebPart::class, 'webattribute_id', 'id');
	}

	public function getValuesInCategoryAttribute() {
		return $this->webParts->sortBy('pivot.attribute_value')->pluck('pivot.attribute_value', 'pivot.attribute_value');
	}



//	public static function selectbox_list() {
//		return self::orderBy('attribute_name')->pluck('attribute_name', 'id')->all();
//	}

//	public function getSlugAttribute($value) {
//		return str_slug($this->attribute_name);
//	}

//	public function scopeCanFilter($query) {
//		return $query->where($this->getTable() . '.can_filter', '1');
//	}

//	public function scopeForFamily($query, $familyId) {
//		if ($familyId instanceof WebFamily) $familyId = $familyId->id;
//
//		return $query
//			->join('WebAttribute_WebFamily', 'WebAttribute_WebFamily.webattribute_id', '=', 'WebAttributes.id')
////			->join('WebFamilies', 'WebFamilies.id', '=', 'WebAttribute_WebFamily.webfamily_id')
//			->where('WebAttribute_WebFamily.webfamily_id', $familyId)
//
////			->get()
//		;
//	}
	

//	public static function attributesForCategoryFilter($category) {
//		return DB::table('WebAttributes')
//			->join('WebAttribute_WebFamily', 'WebAttributes.id', '=', 'WebAttribute_WebFamily.webattribute_id')
//			->join('WebFamily_WebCategory', 'WebFamily_WebCategory.webfamily_id', '=', 'WebAttribute_WebFamily.webfamily_id')
//			->where('WebAttribute_WebFamily.can_filter', 1)
//			->where('webcategory_id', $category->id)
//			->groupBy('WebAttributes.id')
//			->get()
//			;
//	}

//SELECT * from WebAttributes
//JOIN WebAttribute_WebFamily ON (WebAttributes.id = WebAttribute_WebFamily.webattribute_id)
//JOIN WebFamily_WebCategory ON (WebFamily_WebCategory.webfamily_id = WebAttribute_WebFamily.webfamily_id)
//WHERE WebAttributes.can_filter = 1 AND webcategory_id = 2
//GROUP BY WebAttributes.id
//;
	
//	public function valuesCount() {
//		return $this->values()->selectRaw('count(attribute_value) as valuesCount, webattribute_id')->groupBy('webattribute_id');
//	}
//
//	public function getValuesCount() {
//		if (!$this->relationLoaded('valuesCount')) $this->load('valuesCount');
//		$relation = $this->getRelation('valuesCount')->first();
//		return ($relation) ? $relation->valuesCount : null;
//	}

//	use SelectsRelatedCount;
	public function scopeInCollection($query, $webCollection) {
		$webCollectionId = ($webCollection instanceof WebCollection) ? $webCollection->id : $webCollection;
		return $query->whereHas('webFamilies', function ($query) use ($webCollectionId) {
			return $query->inCollection($webCollectionId);
		});
	}

	public function scopeInCategory($query, $webCategory) {
		$webCategoryId = ($webCategory instanceof WebCategory) ? $webCategory->id : $webCategory;
		return $query->whereHas('webFamilies', function ($query) use ($webCategoryId) {
			return $query->inCategory($webCategoryId);
		});
	}

	public function scopeInGroup($query, $webGroup) {
		$webGroupId = ($webGroup instanceof WebGroup) ? $webGroup->id : $webGroup;
		return $query->whereHas('webFamilies', function ($query) use ($webGroupId) {
			return $query->inGroup($webGroupId);
		});
	}

	public static function in($model) {
		if ($model instanceof WebGroup) {return self::inGroup($model);}
		else if ($model instanceof WebCategory) return self::inCategory($model);
		else if ($model instanceof WebCollection) return self::inCollection($model);
	}

	use RevisionableTrait;
}
