<?php

namespace Hilco\Models;

/**
 * @property string $pricelist_connection
 * @property boolean $is_active
 */
class PriceListSchema extends WebModel {
    protected $table = "PriceListSchemas";
    protected $fillable = ["is_active"];
    protected $casts = ["is_active" => "boolean"];

    /**
     * @return string
     */
    public function getPriceListConnection(): string {
        return $this->pricelist_connection;
    }

    /**
     * @return bool
     */
    public function isActive(): bool {
        return $this->is_active;
    }

    /**
     * @return PriceListSchema|null
     */
    public static function getActivePriceListSchema(): ?PriceListSchema {
        return self::where('is_active', '=', 1)->first();
    }

    /**
     * @return PriceListSchema|null
     */
    public static function getInactivePriceListSchema(): ?PriceListSchema {
        return self::where('is_active', '=', 0)->first();
    }
}