<?php

namespace Hilco\Models;

/**
 * Class WebFamilyProductFeature
 * @package Hilco\Models
 * @property integer $webfamily_id
 * @property string $feature_text
 * @property integer $display_order
 * @property string $language_code
 */
class WebFamilyProductFeature extends WebModel {
    protected $table = "WebFamilyProductFeatures";
    protected $fillable = ["webfamily_id", "feature_text", "display_order", "language_code"];

    public function webFamily() {
        return $this->belongsTo(WebFamily::class, 'webfamily_id', 'id');
    }
}