<?php

namespace Hilco\Models;


class PromotionItemQuantityTrigger_Product extends WebModel {

    protected $table = 'PromotionItemQuantityTrigger_Product';
    protected $fillable = ['excluded', 'commit_sequence'];

    public function itemQuantityTrigger() {
        return $this->belongsTo(PromotionItemQuantityTrigger::class,
                                'promotionitemquantitytrigger_id', 'id');
    }

    public function scopeTriggerProduct($query, $trigger_id, $product_id, $product_type) {
        return $query->where(
            [
                'promotionitemquantitytrigger_id' => $trigger_id,
                'product_id' => $product_id,
                'product_type' => $product_type
            ]
        );
    }

    use HasCommitSequence;

}