<?php

namespace Hilco\Models;

/**
 * Hilco\Models\OrderPartLine
 *
 * @property mixed $id
 * @property mixed $part_id
 * @property mixed $quantity
 * @property float $unit_price
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\OrderItem[] $items
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereDivisionId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine wherePlantId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereInvoiceNumber($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereBilltoCustomersegmentId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereSoldtoCustomersegmentId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereFob($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine wherePaymentTerms($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereTaxAmt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereFreightAmt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereInvoiceDate($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereShipDate($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereCarrier($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereShipVia($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereCustomerPo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereShippingPolicy($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereDeletedAt($value)
 * @mixin \Eloquent
 * @property boolean $isKit
 * @property-read \Hilco\Models\Part $part
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine wherePartId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereQuantity($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereUnitPrice($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereIsKit($value)
 * @property mixed $salesorder_id
 * @property integer $line_number
 * @property integer $line_order
 * @property string $line_suborder
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereSalesorderId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereLineNumber($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereLineOrder($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderPartLine whereLineSuborder($value)
 */
class OrderPartLine extends UuidModel
{
    protected $table = 'SalesOrderPartLines';

    public function part() {
        return $this->belongsTo(Part::class, 'part_id');
    }

    public function priceLists() {
        return $this->hasMany(PriceList::class, 'part_id', 'part_id');
    }

    public function getPriceListPriceAttribute() {
        $priceLists = $this->priceLists->sortByDesc('quantity_level');
        foreach ($priceLists as $priceList) {
            if ($this->quantity >= $priceList->quantity_level) {
                return $priceList->price;
            }
        }
        return null;
    }
}
