<?php

namespace Hilco\Models;

class Call extends UuidModel {
	protected $table = "Calls";
    protected $fillable = [
        'salesrep_id',
        'customer_id',
        'start_time',
        'reason_type',
        'contact_type',
        'abcd_call',
    ];

    use HasCommitSequence;

    public function salesRep() {
	    return $this->belongsTo(SalesRep::class, 'salesrep_id', 'id');
    }


    public static function getLatestCallFromListOfCustomers($customers) {
	    $latestCall = null;
	    foreach ($customers as $customer) {
	        $call = $customer->getLatestCall();
	        if ($call != null && ($latestCall == null || $latestCall->getStartTime() < $call->getStartTime())) {
	            $latestCall = $call;
            }
        }

        return $latestCall;
    }

    public function getStartTime() {
	    return $this->start_time;
    }
}