<div class="panel panel-info" style="border-color: {{$tierTextColorHex}}; border-width: 6px;">
    <div class="panel-body" >
        <a href="{{ route('rewards.status') }}">
            <div class="row vertical-align">
                <div class="col-sm-3 @if($tier == 1) col-lg-3 @else col-lg-2 @endif">
                    <img src="{{ rewards()->tierImage() }}" class="img-responsive center-block" alt="">
                </div>
                <div class="col-sm-9 @if($tier == 1) col-lg-9 @else col-lg-10 @endif">
                        @if ($tier == 1)
                            <h4 class="text-center" style="margin-top: 0; font-size: 40px;"><i>@lang('rewards.get_started_as_a_hilco_rewards_partner')</i></h4>
                        @else
                            <h4 class="text-center" style="margin-top: 0; font-size: 40px;">
                                <i>
                                    {!! trans('rewards.thank_you_for_being_a_rewards_member', ['color' => $tierTextColorHex, 'TIER' => $tierName]) !!}
                                </i>
                            </h4>
                            <h5 class="text-center" style="margin-top: 0; font-size: 25px;">
                                {!! trans('rewards.tier_members_enjoy_an_average_annual_savings_of_x_percent', ['color' => $tierTextColorHex, 'TIER' => $tierName, 'savings' => rewards()->tierAverageAnnualSavings()]) !!}
                            </h5>
                    @endif
                </div>
            </div>
            @if($tier != 4)
                <div class="col-xs-12">
                    <table width="100%">
                        <tr height="125px">
                            <td width="40%">
                                <font style="font-size: 35px; vertical-align: center; text-align: right">
                                    {!! trans('rewards.unlock_tier', ['color' => $nextTierTextColorHex, 'TIER' => $nextTierName]) !!}
                                    <b>&nbsp; &#x27F6;</b>
                                </font>
                            </td>
                            <td width="25%">
                                <div class="progress progress-rewards" style="margin-bottom: 1em;">
                                    <div
                                            data-qtip-id="details-qtip" class="rewards-progress-bar progress-bar @if($tier == 1) rewards-bronze @elseif($tier == 2) rewards-silver @elseif($tier == 3) rewards-gold @elseif($tier == 4) rewards-platinum @else progress-bar-info @endif "
                                            style="width: 70%">
                                    </div>
                                    <div style="padding-top:3px;">
                                        <strong><font size="5"><center>{{$categoriesToUpgrade}}</center></font></strong>
                                    </div>
                                    <div style="display: none;" id="details-qtip">
                                        {{$categoriesToUpgrade}}&nbsp;@lang('rewards.product_categories_away')
                                    </div>
                                </div>
                                <center style="font-color: black;">@lang('rewards.product_categories_away')</center>
                            </td>
                            <td width="10%">
                                <font style="font-size: 30px;"><center>OR</center></font>
                            </td>
                            <td width="25%">
                                <div class="progress progress-rewards" style="margin-bottom: 1em;">
                                    <div
                                            data-qtip-id="details-qtip" class="rewards-progress-bar progress-bar @if($tier == 1) rewards-bronze @elseif($tier == 2) rewards-silver @elseif($tier == 3) rewards-gold @elseif($tier == 4) rewards-platinum @else progress-bar-info @endif "
                                            style="width: 70%">
                                    </div>
                                    <div style="padding-top:3px;">
                                        <strong><font size="4"><center>{{b2b()->formatPrice(ceil($spendingToUpgrade), 0)}}</center></font></strong>
                                    </div>
                                    <div style="display: none;" id="details-qtip">
                                        {{b2b()->formatPrice('$%i', ceil($spendingToUpgrade), 2)}} @lang('rewards.in_purchases_away')
                                    </div>
                                </div>
                                <center style="font-color: black;">@lang('rewards.in_purchases_away')</center>
                            </td>
                        </tr>
                    </table>
                </div>
            @endif
            <div>
                <center><i>@lang('rewards.click_to_see_more')</i></center>
            </div>
        </a>
    </div>
</div>
