@if(isset($mode) && $mode === 'view')
    <div class="row">
        <div
                @if(isset($full) && $full)
                class="col-xs-12"
                @else
                class="col-xs-8 col-xs-offset-2"
                @endif
        >
            @include('partials.webpImage', [
                'webpUrl' => webAssetUrl($webAssetId) . '?webp=1',
                'jpgUrl' => webAssetUrl($webAssetId),
                'attributes' => [
                    'class' => 'img-responsive',
                    'style' => 'width: 100%',
                    'alt' => isset($alttag) ? $alttag : '',
                ]
            ])
        </div>
    </div>
    <br>
@else
    <div class="view-container {{$default? 'default visible' : 'alternate hidden'}}" data-view-id="{{$viewId}}" data-target-customers="@if(isset($targetCustomers))  {{json_encode($targetCustomers)}} @endif" data-visible-dates="@if(isset($visibleDates))  {{json_encode($visibleDates)}} @endif" data-default-visibility="@if(isset($defaultVisibility) && trim($defaultVisibility) != "")  {{$defaultVisibility}} @else Visible @endif">
        <img data-web-asset-id="{{ $webAssetId }}" id="jumbotronThumbnail" src="{{ webAssetUrl($webAssetId) }}" alt="@if(isset($alttag)) {{ $alttag }} @endif" class="img-responsive center-block">
        @lang('hilco::app.alternate_tag') <a href="#" class="jumbotron-alttag" data-img-alttag="@if(isset($alttag))  {{ $alttag }} @endif">@if(isset($alttag) && trim($alttag) != "") {{ $alttag }} @else None  @endif</a><br>
        @include('hilco::components.targetCustomer.visibilityControls', ['default' => $default ?? true, 'defaultVisibility' => $defaultVisibility ?? '', 'targetCustomersFormatted' => $targetCustomersFormatted ?? '', 'visibleDatesFormatted' => $visibleDatesFormatted ?? ''])
    </div>
@endif