<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use LogicException;

/**
 * Class Promotion
 * @package Hilco\Models
 *
 * @method static Builder active()
 */
class PromotionCurrentOrderTrigger extends WebModel
{
    protected $table = 'PromotionCurrentOrderTriggers';
    protected $fillable = ['minimum_quantity', 'via_web', 'via_cst'];

    public function promotion() {
        return $this->morphToMany(Promotion::class, 'trigger', 'PromotionTriggers', 'promotion_id');
    }

    public function webGroups() {
        return $this
            ->morphedByMany(WebGroup::class, 'product', 'PromotionCurrentOrderTrigger_Product')
            ->withPivot(['excluded'])
        ;
    }

    public function webCategories() {
        return $this
            ->morphedByMany(WebCategory::class, 'product', 'PromotionCurrentOrderTrigger_Product')
            ->withPivot(['excluded'])
        ;
    }

    public function webCollections() {
        return $this
            ->morphedByMany(WebCollection::class, 'product', 'PromotionCurrentOrderTrigger_Product')
            ->withPivot(['excluded'])
        ;
    }

    public function webFamilies() {
        return $this
            ->morphedByMany(WebFamily::class, 'product', 'PromotionCurrentOrderTrigger_Product')
            ->withPivot(['excluded'])
        ;
    }


}
