<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;


/**
 * Hilco\Models\SalesRep
 *
 * @property integer $id
 * @property string $username
 * @property string $password
 * @property string $role
 * @property string $language_locale
 * @property string $timezone
 * @property string $firstname
 * @property string $lastname
 * @property string $pointman_name
 * @property string $company
 * @property string $division
 * @property string $department
 * @property string $title
 * @property string $email
 * @property string $phone
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereUsername($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep wherePassword($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereRole($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereLanguageLocale($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereTimezone($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereFirstname($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereLastname($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep wherePointmanName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereCompany($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereDivision($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereDepartment($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereTitle($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereEmail($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep wherePhone($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereDeletedAt($value)
 * @mixin \Eloquent
 */

class SalesRep extends WebModel
{
	protected $table = "SalesReps";
	protected $fillable = ['username', 'password', 'role', 'timezone', 'commit_sequence'];


    use HasCommitSequence;

	public function ImportUser()
	{
		return Import_User::where("username", "=", $this->getAttribute("username"))->first();
	}

	public function calls() {
	    return $this->hasMany(Call::class, 'salesrep_id', 'id');
    }

    public function callsCount() {
	    return $this->hasMany(Call::class, 'salesrep_id', 'id')
            ->selectRaw('COUNT(Calls.id) as aggregate')
            ->groupBy('salesrep_id')
        ;
    }

    public function getCallsCountAttribute() {
        $relations = $this->relations;
	    if (!isset($relations['callsCount'])) $this->load('callsCount');
	    $related = $this->getRelation('callsCount')->first();
	    return ($related) ? $related->aggregate : 0;
    }

}
