<?php

namespace Hilco\Models;

use DB;

/**
 * Class WebPart_WebFamily
 * @package Hilco\Models
 * @property int $id
 * @property integer $webfamily_id
 * @property integer $webpart_id
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property-read WebFamily $webFamily
 * @property-read WebPart $webPart
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebPart_WebFamily whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebPart_WebFamily whereWebPartId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebPart_WebFamily whereWebFamilyId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebPart_WebFamily whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebPart_WebFamily whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebPart_WebFamily whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebPart_WebFamily whereDeletedAt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebPart_WebFamily inHierarchy($value)
 */
class WebPart_WebFamily extends WebModel {
    protected $table = 'WebPart_WebFamily';
    protected $fillable = ['webfamily_id', 'webpart_id', 'is_family_image'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function webFamily() {
        return $this->belongsTo(WebFamily::class, 'webfamily_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function webPart() {
        return $this->belongsTo(WebPart::class, 'webpart_id', 'id');
    }

    /**
     * Scope to get WebPart_WebFamily rows that are in a given WebHierarchy
     * @param $query
     * @param null $webhierarchy_id
     * @return mixed
     */
    public function scopeInHierarchy ($query, $webhierarchy_id = null) {
        if (is_null($webhierarchy_id)) {
            $webhierarchy_id = b2b()->activeWebHierarchy()->id;
        }

        return $query->whereExists(function ($query) use ($webhierarchy_id) {
            return $query
                ->select(DB::raw('1'))
                ->from('WebFamilies')
                ->whereRaw('WebFamilies.id = WebPart_WebFamily.webfamily_id')
                ->whereRaw('WebFamilies.deleted_at = 0')
                ->whereExists(function ($query) use ($webhierarchy_id) {
                    return $query
                        ->select(DB::raw('1'))
                        ->from('WebFamily_WebCollection')
                        ->whereRaw('WebFamilies.id = WebFamily_WebCollection.webfamily_id')
                        ->whereRaw('WebFamily_WebCollection.deleted_at = 0')
                        ->whereExists(function ($query) use ($webhierarchy_id) {
                            return $query
                                ->select(DB::raw('1'))
                                ->from('WebCollections')
                                ->whereRaw('WebCollections.id = WebFamily_WebCollection.webcollection_id')
                                ->whereRaw('WebCollections.deleted_at = 0')
                                ->whereExists(function ($query) use ($webhierarchy_id) {
                                    return $query
                                        ->select(DB::raw('1'))
                                        ->from('WebCollection_WebCategory')
                                        ->whereRaw('WebCollections.id = WebCollection_WebCategory.webcollection_id')
                                        ->whereRaw('WebCollection_WebCategory.deleted_at = 0')
                                        ->whereExists(function ($query) use ($webhierarchy_id) {
                                            return $query
                                                ->select(DB::raw('1'))
                                                ->from('WebCategories')
                                                ->whereRaw('WebCategories.id = WebCollection_WebCategory.webcategory_id')
                                                ->whereRaw('WebCategories.deleted_at = 0')
                                                ->whereExists(function ($query) use ($webhierarchy_id) {
                                                    return $query
                                                        ->select(DB::raw('1'))
                                                        ->from('WebCategory_WebGroup')
                                                        ->whereRaw('WebCategories.id = WebCategory_WebGroup.webcategory_id')
                                                        ->whereRaw('WebCategory_WebGroup.deleted_at = 0')
                                                        ->whereExists(function ($query) use ($webhierarchy_id) {
                                                            return $query
                                                                ->select(DB::raw('1'))
                                                                ->from('WebGroups')
                                                                ->whereRaw('WebGroups.id = WebCategory_WebGroup.webgroup_id')
                                                                ->whereRaw('WebGroups.deleted_at = 0')
                                                                ->whereExists(function ($query) use ($webhierarchy_id) {
                                                                    return $query
                                                                        ->select(DB::raw('1'))
                                                                        ->from('WebGroup_WebHierarchy')
                                                                        ->whereRaw('WebGroups.id = WebGroup_WebHierarchy.webgroup_id')
                                                                        ->whereRaw('WebGroup_WebHierarchy.deleted_at = 0')
                                                                        ->whereRaw("WebGroup_WebHierarchy.webhierarchy_id = $webhierarchy_id");
                                                                });
                                                        });
                                                });
                                        });
                                });
                        });
                });
        });
    }
}