<?php

namespace Hilco\Models;

use DB;
use Illuminate\Database\Eloquent\Model;


class RateShopAPIDetail extends Model {
	protected $table = "NewRateShopAPIDetails";

    public function scopeForGroupCode ($query, $groupCode) {
        return
            $query
                ->join('NewRateShopGroups', 'NewRateShopAPIDetails.delivery_method', '=', 'NewRateShopGroups.delivery_method')
                ->where('NewRateShopAPIDetails.delivery_term', '=', DB::raw('`NewRateShopGroups`.`delivery_term`'))
                ->whereRaw("NewRateShopGroups.group_code = $groupCode")
                ->groupBy('NewRateShopAPIDetails.delivery_method', 'NewRateShopAPIDetails.delivery_term')
        ;
    }
}
