<?php

namespace Hilco\Models;

class AdditionalTaxCustomerSegment extends UuidModel
{
    protected $table = 'AdditionalTax_CustomerSegment';

    public function customerSegments()
    {
        return $this->belongsTo(CustomerSegment::class, 'customersegment_id');
    }

    public function additionalTax() {
        return $this->hasMany(AdditionalTax::class, 'tax_code', 'tax_code')
            ->where('deleted_at', '0000-00-00 00:00:00')
            ->where(function ($query) {
                $query->where(function ($query) {
                    return $query->where('effective_date', '<=', date('Y-m-d', time()))
                        ->where('expiration_date', '>=', date('Y-m-d', time()));
                })
                    ->orWhere('expiration_date', '0000-00-00');
            });
    }
}
