<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Hilco\Models\PartAlias
 *
 * @property-read integer $id
 * @property-read string $part_no
 * @property-read string $alias_no
 * @property-read string $alias_origin
 * @property-read Part $part
 */
class PartAlias extends WebModel {
    protected $table = "PartAliases";

    /**
     * @return BelongsTo
     */
    public function part(): BelongsTo {
        return $this->belongsTo(Part::class, "part_no", "part_no");
    }

    /**
     * @return string
     */
    public function getAliasNo(): string {
        return $this->alias_no;
    }
}