<?php

namespace Hilco\Models;

class PromotionItemDiscountAction extends PromotionActionDetails {
    protected $table = 'PromotionItemDiscountActions';
    protected $fillable = ['quantity_to_discount', 'discount_percent', 'discount_entire_order', 'discount_note'];
//    protected $with = ['webGroups','webCategories','webCollections','webFamilies','webParts'];

    public function promotion() {
        return $this->morphToMany(Promotion::class, 'action',
                                'PromotionActions', 'promotion_id',
                        'promotionitemdiscountaction_id');
    }

    public function webGroups() {
        return $this
            ->morphedByMany(WebGroup::class, 'product',
                            'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
            ->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
    }

    public function webCategories() {
        return $this
            ->morphedByMany(WebCategory::class, 'product',
                            'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
            ->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
    }

    public function webCollections() {
        return $this
            ->morphedByMany(WebCollection::class, 'product',
                            'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
            ->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
    }

    public function webFamilies() {
        return $this
            ->morphedByMany(WebFamily::class, 'product',
                            'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
            ->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
    }

    public function webParts() {
        return $this
            ->morphedByMany(WebPart::class, 'product',
                            'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
            ->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
    }

    public function getRelationForProductTableType($tableType) {
        //
        if($tableType === 'webFamily' || $tableType === 'webCategory') {
            $relationName = substr($tableType, 0, -1);
            $relationName .= 'ies';
        } else {
            $relationName = $tableType . 's';
        }
        return $this->$relationName();
    }

    public function isApplicable(Part $part) {
        if ($this->discount_entire_order) {
            return true;
        }

        $actionWebGroups = $this->webGroups;
        $actionWebCategories = $this->webCategories;
        $actionWebCollections = $this->webCollections;
        $actionWebFamilies = $this->webFamilies;
        $actionWebParts = $this->webParts;

        $webPartToCheck = $part->webPart;
        if (isset($webPartToCheck)) {
            foreach ($actionWebParts as $actionWebPart) {
                if ($actionWebPart->id == $webPartToCheck->id) {
                    return ($actionWebPart->pivot->excluded == 0);
                }
            }

            $webFamilyToCheck = $webPartToCheck->webFamily;

            if (isset($webFamilyToCheck)) {
                foreach ($actionWebFamilies as $actionWebFamily) {
                    if ($actionWebFamily->id == $webFamilyToCheck->id) {
                        return ($actionWebFamily->pivot->excluded == 0);
                    }
                }

                foreach ($webFamilyToCheck->webCollections as $webCollectionToCheck) {
                    foreach ($actionWebCollections as $actionWebCollection) {
                        if ($actionWebCollection->id == $webCollectionToCheck->id) {
                            return ($actionWebCollection->pivot->excluded == 0);
                        }
                    }

                    foreach ($webCollectionToCheck->webCategories as $webCategoryToCheck) {
                        foreach ($actionWebCategories as $actionWebCategory) {
                            if ($actionWebCategory->id == $webCategoryToCheck->id) {
                                return ($actionWebCategory->pivot->excluded == 0);
                            }
                        }

                        foreach ($webCategoryToCheck->webGroups as $webGroupToCheck) {
                            foreach ($actionWebGroups as $actionWebGroup) {
                                if ($actionWebGroup->id == $webGroupToCheck->id) {
                                    return ($actionWebGroup->pivot->excluded == 0);
                                }
                            }
                        }
                    }
                }
            }
        }

        return false;
    }

    public function takeAction(Customer $soldToCustomer, $webCartItems, &$status) {
        // TODO: Implement takeAction() method
        if($this->discount_entire_order){
            foreach($status['items'] as $item) {
                $discountPercent = $this->discountPercent;
                $discountAmount = round($item['basePrice'] * ($discountPercent / 100), 2);
                $extendedDiscountAmount = $discountAmount * $item['quantity'];
                $baseDiscountAmount = round($item['basePrice'] * ($discountPercent / 100), 2);
                $discountedPrice = $item['basePrice'] - $baseDiscountAmount;
                $extendedPrice = $discountedPrice * $item['quantity'];

            }
        } else {
//            foreach($status['items'] as $item) {
//                if ($this->isApplicable($item)) {
//                    $discountPercent = $this->discountPercent;
//                    $discountAmount = round($item['basePrice'] * ($discountPercent / 100), 2);
//                    $extendedDiscountAmount = $discountAmount * $item['quantity'];
//                    $baseDiscountAmount = round($item['basePrice'] * ($discountPercent / 100), 2);
//                    $discountedPrice = $item['basePrice'] - $baseDiscountAmount;
//                    $extendedPrice = $discountedPrice * $item['quantity'];
//                }
//            }
        }
    }

    public static function boot() {
        parent::boot();

        static::deleted(function (PromotionItemDiscountAction $promotionItemDiscountAction) {
            $promotionItemDiscountActionProducts =
                PromotionItemDiscountAction_Product::where('promotionitemdiscountaction_id', '=', $promotionItemDiscountAction->id);
            foreach ($promotionItemDiscountActionProducts as $promotionItemDiscountActionProduct) {
                $promotionItemDiscountActionProduct->delete();
            }
        });
    }
}
