<?php

namespace Hilco\Models;

use DB;

/**
 * Hilco\Models\FormFields
 *
 * @property integer $id
 * @property string $label
 * @property string $type
 * @property string $date_modified
 * @property string $deleted_at
 */
class FormFields extends WebModel
{
    protected $table = "FormFields";
    protected $fillable = ['label','type'];
    public static $types;

    public function __construct($attributes = [])
    {
        parent::__construct($attributes);

        $this->types = [
            'text'       => trans('hilco::app.text_field'),
            'text_label' => trans('hilco::app.text_label'),
            'select'     => trans('hilco::app.select_box'),
            'checkbox'   => trans('hilco::app.check_box'),
            'radio'      => trans('hilco::app.radio_button'),
        ];
    }

    public function webForms() {
        return $this->belongsToMany(WebForms::class, 'WebForm_FormField', 'formfield_id', 'webform_id');
    }

    public function values() {
        return $this->hasMany(FormFieldValues::class, 'formfield_id', 'id');  
    }

    public function attributes() {
        return $this->hasMany(FormFieldsAttributes::class, 'formfield_id', 'id');
    }

}
