<?php

namespace Hilco\Models;

use DateTimeInterface;

/**
 * Hilco\Model\ArtisanCommand
 * @property string $command_class
 * @property string $date_last_run
 * @property boolean $is_running
 * @property string $last_run_result
 * @property string $last_error_message
 * @property string $last_exception
 * @property mixed $failed_run_data
 */
class ArtisanCommand extends WebModel {
    protected $table = 'ArtisanCommands';
    protected $fillable = [
        'command_class','date_last_run','is_running','last_run_result','last_error_message','last_exception','failed_run_data'
    ];
    protected $casts = [
        'date_last_run' => 'datetime',
        'failed_run_data' => 'array',
        'is_running' => 'boolean',
        'last_run_result' => RunResult::class,
    ];

    /**
     * see https://laravel.com/docs/10.x/eloquent-mutators#date-casting
     * @param DateTimeInterface $dateTime
     * @return string
     */
    protected function serializeDate (DateTimeInterface $dateTime): string {
        return $dateTime->format('Y-m-d');
    }
}