<?php

namespace Hilco\Models;

class AdditionalTax extends UuidModel
{
    protected $table = 'AdditionalTaxes';

    public function additionalTaxCustomerSegment() {
        return $this->hasMany(AdditionalTaxCustomerSegment::class, 'tax_code', 'tax_code');
    }

	public function scopeInEffect($query) {
		return $query
			->where(function($query) {
				$query->where('effective_date', '=', '0000-00-00')
					->orWhere('effective_date', '<', date('Y-m-d'));
			})
			->where(function($query) {
				$query->where('expiration_date', '=', '0000-00-00')
					->orWhere('expiration_date', '>', date('Y-m-d'));
			});
	}
}
