<?php

namespace Hilco\Models;
use Arr;
use Eloquent;
use Hilco\SoftDeletes;
use URL;

/**
 * Hilco\Models\Plant
 *
 * @property mixed $id
 * @property string $plant
 * @property string $plant_name
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant wherePlant($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant wherePlantName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $date_uploaded
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant whereDateUploaded($value)
 */
class Plant extends Eloquent
{
	protected $table = 'Plants';
    protected $connection = 'hilco-live';

	const AUSTRALIA_CODE    = 'U81';
	const BOZEMAN_CODE      = 'U41';
	const DALLAS_CODE       = 'U21';
    const HAWES_CODE        = 'G11';
    const ICOAT_WAREHOUSE   = 'U22';
    const INY_FACILITY      = 'D13';
    const INY_WAREHOUSE     = 'D14';
    const KARBEN_CODE       = 'D11';
    const LASVEGAS_CODE     = 'U31';
    const NEWZEALAND_CODE   = 'U91';
    const OHIO_CODE         = 'U51';
	const PLAINVILLE_CODE   = 'U11';

    protected static $plantClusters = [
        self::ICOAT_WAREHOUSE => [
            self::ICOAT_WAREHOUSE,
        ],
//        self::INY_FACILITY => [
//            self::KARBEN_CODE,
//            self::INY_FACILITY,
//            self::INY_WAREHOUSE,
//        ],
//        self::INY_WAREHOUSE => [
//            self::KARBEN_CODE,
//            self::INY_FACILITY,
//            self::INY_WAREHOUSE,
//        ],
        self::KARBEN_CODE => [
            self::KARBEN_CODE,
//            self::INY_FACILITY,
//            self::INY_WAREHOUSE,
        ],
        self::LASVEGAS_CODE => [
            self::LASVEGAS_CODE,
            self::OHIO_CODE,
        ],
//        self::NEWZEALAND_CODE => [
//            self::AUSTRALIA_CODE,
//            self::NEWZEALAND_CODE,
//        ],
        self::OHIO_CODE => [
            self::LASVEGAS_CODE,
            self::OHIO_CODE,
        ],
        self::PLAINVILLE_CODE => [
            self::LASVEGAS_CODE,
            self::OHIO_CODE,
        ],
    ];

    /**
     * @return string[][]
     */
    public static function getPlantClusters(): array {
        return self::$plantClusters;
    }

	public function plantAddress() {
	    return $this->hasOne(PlantAddress::class, 'plant_id', 'id');
    }

    public function getPlantDescAttribute() {
	    return $this->plant . ' - ' . $this->plant_name;
    }

    public static function defaultPlant() {
	    if (strpos(URL::current(), '.co.uk')) {
	        return self::where('plant', '=', Plant::HAWES_CODE)->first();
        }
	    if (strpos(URL::current(), '.com.au')) {
	        return self::where('plant', '=', Plant::AUSTRALIA_CODE)->first();
        }
        if (strpos(URL::current(), '.de')) {
            return self::where('plant', '=', Plant::KARBEN_CODE)->first();
        }
	    return self::where('plant', '=', Plant::OHIO_CODE)->first();
    }

    /**
     * @return array
     * @deprecated Pretty sure this was only actively used by InventoryItem::getInStockAttribute(), and the in_stock attribute isn't used anymore
     */
    public static function lasVegasLogicPlants() {
	    return [
	        Plant::OHIO_CODE,
            Plant::LASVEGAS_CODE,
        ];
    }

    /**
     * @return array of warehouse (plant) codes that are used in web inventory cluster logic
     */
    public static function inventoryClusterLogicPlants($plantCode = self::OHIO_CODE): array {
	    $cluster = Arr::get(self::$plantClusters, $plantCode);
        if (is_null($cluster)) {
            return [$plantCode];
        } else {
            return $cluster;
        }
    }

    /**
     * @return Plant|null
     */
    public static function getICoatPlant(): ?Plant {
        return Plant::where('plant', self::ICOAT_WAREHOUSE)->first();
    }
    use SoftDeletes;
}