<?php

namespace Hilco\Models;

use Flynsarmy\DbBladeCompiler\Facades\DbView;

class WebSiloOverride extends WebModel  {
	protected $table = "WebSiloOverrides";
	protected $fillable = ['websilo_id', 'overrideable_type', 'overrideable_id', 'name', 'is_visible', 'primary_webasset_id', 'detail', 'en_name', 'de_name', 'fr_name'];

	protected $casts = [
	    'is_visible' => 'boolean'
	];
    protected $with = ['translations'];

	use HasTranslations;

	public function primaryImage() {
	    return $this->belongsTo(WebAsset::class, 'primary_webasset_id', 'id');
    }

    public function webSilo() {
	    return $this->belongsTo(WebSilo::class, 'websilo_id', 'id');
    }

    public function overrideable() {
	    return $this->morphTo();
    }

    public function setDetailAttribute($detail) {
        if (str_contains($detail, 'mceNonEditable')) {
            throw new \InvalidArgumentException(trans('hilco::app.error_while_saving_details_please_try_again'));
        }

        $newDetail = preg_replace_callback('%<!--\\[\\[\\[(.*?)\|(.*?)\\]\\]\\]-->%', function ($matches) {
            return "@include('$matches[1]', " . str_replace(["\n", "\r"], '', var_export(json_decode($matches[2], true), true)) . ")";
        }, $detail);

        $this->attributes['detail'] = $newDetail;
    }

    public function getDetailForEditAttribute() {
        return DbView::make($this)->with(['edit' => true, 'wrap' => true])->render();
    }
}
