<?php

namespace Hilco\Models;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;


class ItemDiscount extends Model {
	protected $table = "ItemDiscounts";

    public function scopeActive($query) {
        return $query
            ->whereRaw('start_date <= NOW()')
            ->where(function ($wheres) {
                return $wheres
                    ->whereRaw('end_date >= NOW()')
                    ->orWhere('end_date', '=', '1753-01-01')
                    ;
            })
            ;
    }

    public function scopeItemDiscounts($query) {
        return $query->where('type', '=', 'Item')->active();
    }

    public function scopeGroupDiscounts($query) {
        return $query->where('type', '=', 'Item Disc. Group')->active();
    }

    public function scopeResourceGroupDiscounts($query) {
        return $query->where('type', '=', 'Ressource Group')->active();
    }

    public function scopeCustomers($query) {
	    return $query->where('sales_type', '=', 'Customer');
    }

    public function scopeCustomerDiscountGroups($query) {
        return $query->where('sales_type', '=', 'Customer Disc. Group');
    }

    public function scopeAllCustomers($query) {
        return $query->where('sales_type', '=', 'All Customers');
    }

    public function scopePartNumber($query, $partNumber) {
        return $query->itemDiscounts()->where('code', '=', $partNumber);
    }


    public function scopeCustomer($query, $customerNumber) {
        return $query->customers()->where('sales_code', '=', $customerNumber);
    }

    public function scopeCustomerDiscountGroup($query, $group) {
        return $query->customerDiscountGroups()->where('sales_code', '=', $group);
    }
}
