<?php

namespace Hilco\Models;

class VATTax extends UuidModel
{
    protected $table = 'VATTaxes';

    public function parts() {
        return $this->hasMany(Part::class, 'vat_code', 'vat_code');
    }

    public function scopeActive($query) {
        return $query
            ->where(function ($query) {
                return $query
                    ->where('effective_date', '<=', 'DATE(NOW())')
                    ->where('expiration_date', '>=', 'DATE(NOW())')
                ;
            })
            ->orWhere('expiration_date', '=', '0000-00-00')
        ;
    }

    public function scopeCode($query, $code) {
        return $query->where('vat_code', '=', $code);
    }

    public static function rateForCode($code) {
        return self::active()->code($code)->value('tax_percentage');
    }

    public static function standardRate() {
        return self::rateForCode('STD-RATED');
    }
}
