<?php

namespace Hilco\Models;

use Klaviyo\Exception\KlaviyoException;
use Klaviyo\Klaviyo;
use Log;

/**
 * Class PromotionKlaviyoListTrigger
 * @package Hilco\Models
 * @property string $klaviyo_list
 * @property bool $check_legacy_rewards
 */
class PromotionKlaviyoListTrigger extends PromotionTriggerDetails {
    protected $table = "PromotionKlaviyoListTriggers";
    protected $fillable = ['klaviyo_list', 'check_legacy_rewards'];
    protected $casts = ['check_legacy_rewards' => 'boolean'];

    public function isTriggered (Customer $soldToCustomer, $webCartItems, $distinctPartInfo = []): bool {
        if ($this->check_legacy_rewards && isset($soldToCustomer->legacyRewardsCustomer)) {
            return true;
        }

        return $soldToCustomer->isSubscribedToKlaviyoList($this->klaviyo_list);
    }

    public function postTriggerOperation($soldToCustomer){}
}