<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Builder;

/**
 * Hilco\Models\BannedApiUser
 * @property-read integer $id
 * @property-read integer $webuser_id
 * @method static Builder byWebUserId($webUserId)
 */
class BannedApiUser extends WebModel {
    protected $table = "BannedApiUsers";

    /**
     * @param Builder $query
     * @param $webUserId
     * @return Builder
     */
    public function scopeByWebUserId(Builder $query, $webUserId): Builder {
        return $query->where('webuser_id', $webUserId);
    }
}