@foreach($alternateViews ?? [] as $alternateId => $altView)
    @if(inDateRange(Arr::get($altView, 'visibleDates', [])) && ($targetType = customerIsTargeted(Arr::get($altView, 'targetCustomers', []), false)))
        @php
            $bladeViewArgs = $altView;
            $personalizationLog = \Hilco\Models\PersonalizationUsageLog::create([
                'user_id' => auth()->user()->id,
                'url' => request()->url(),
                'blade' => $blade,
                'alternate_id' => $alternateId,
                'link' => implode(',', extractLinks($bladeViewArgs)),
                'target_type' => $targetType,
                'target_customers' => json_encode(Arr::get($altView, 'targetCustomers', []))
            ]);
            $bladeViewArgs['alternateLogId'] = $personalizationLog->id;
            $visibleDates = Arr::get($altView, 'visibleDates', []);
            $defaultVisibility = 'Visible';
        @endphp
        @break
    @endif
@endforeach
@if(inDateRange($visibleDates ?? []) && trim($defaultVisibility ?? 'Visible') !== 'Hidden')
    @include($blade, array_merge($bladeViewArgs, ['mode' => 'view']))
@endif
