<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use LogicException;

class PromotionCustomerTrigger extends PromotionTriggerDetails {
    protected $table = 'PromotionCustomerTriggers';
    protected $fillable = ['target_all_customers', 'one_time_use', 'commit_sequence'];

    /**
     * @return BelongsToMany
     */
    public function customers() {
        return $this->belongsToMany(Customer::class, 'PromotionCustomerTrigger_Customer', 'promotioncustomertrigger_id', 'customer_id')
                    ->wherePivot('deleted_at', '=', DB::raw(0))
                    ->withPivot(['excluded', 'temporary_email', 'redeemed'])
                    ->with(['webUsers', 'contacts'])
            ;
    }

    public function isTriggered(Customer $soldToCustomer, $webCartItems, $distinctPartInfo = []) {
        if($this->one_time_use) {
            $customer = $this->customers()->wherePivot('customer_id', '=', $soldToCustomer->id)->where('redeemed', 0)->first();
            if (is_null($customer) && $this->target_all_customers) {
                return true;
            }
        } else {
            if ($this->target_all_customers) {
                return true;
            } else {
                $customer = $this->customers()->wherePivot('customer_id', '=', $soldToCustomer->id)->first();
            }
        }
        return !is_null($customer);
    }

    public function postTriggerOperation($soldToCustomer) {
        $this->customers()->updateExistingPivot($soldToCustomer->id, array('redeemed' => 1));
    }

    public static function boot() {
        parent::boot();

        static::deleted(function (PromotionCustomerTrigger $promotionCustomerTrigger) {
            $promotionCustomerTriggerCustomers =
                PromotionCustomerTrigger_Customer::where('promotioncustomertrigger_id', '=', $promotionCustomerTrigger->id)->get();
            foreach ($promotionCustomerTriggerCustomers as $promotionCustomerTriggerCustomer) {
                $promotionCustomerTriggerCustomer->delete();
            }
        });
    }
}
