@foreach($alternateViews ?? [] as $alternateId => $altView)
    @if(inDateRange(Arr::get($altView, 'visibleDates', [])) && ($targetType = customerIsTargeted(Arr::get($altView, 'targetCustomers', []), false)))
        @php
            $bladeViewArgs = $altView;
            $args = [
                'url' => request()->url(),
                'blade' => $blade,
                'alternate_id' => $alternateId,
                'link' => implode(',', extractLinks($bladeViewArgs)),
                'target_type' => $targetType,
                'target_customers' => json_encode(Arr::get($altView, 'targetCustomers', []))
            ];
            $user = auth()->user();
            if ($user){
                $args['user_id'] = $user->id;
            }
            $personalizationLog = \Hilco\Models\PersonalizationUsageLog::create($args);
            $bladeViewArgs['alternateLogId'] = $personalizationLog->id;
            $visibleDates = Arr::get($altView, 'visibleDates', []);
            $defaultVisibility = 'Visible';
        @endphp
        @break
    @endif
@endforeach
@if(inDateRange($visibleDates ?? []) && trim($defaultVisibility ?? 'Visible') !== 'Hidden')
    @include($blade, array_merge($bladeViewArgs, ['mode' => 'view']))
@endif
