<?php

namespace Hilco\Models;

use DB;

/**
 * Hilco\Models\WebDetailTab
 *
 * @property integer $id
 * @property string $name
 * @property string $body
 * @property string $date_modified
 * @property string $deleted_at
 */
class WebDetailTab extends WebModel
{
    protected $table = "WebDetailTabs";
    protected $fillable = ['name','body'];

    public function webFamilies() {
        return $this->belongsToMany(WebFamily::class, 'WebDetailTab_WebFamily', 'webdetailtab_id', 'webfamily_id')->withPivot('is_visible');
    }

}
