@if($edit)
    <div class="mceNonEditable component-container" data-component-key="jumbotron">
<a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('hilco::app.jumbotron')</h4>
        <p>@lang('hilco::app.displays_a_large_banner_across_the_entire_width_of_the_page')</p>
        <img data-web-asset-id="{{ $webAssetId }}" id="jumbotronThumbnail" src="{{ webAssetUrl($webAssetId) }}" alt="@if(isset($alttag)) {{ $alttag }} @endif" class="img-responsive center-block">
        @lang('hilco::app.alternate_tag') <a href="#" class="jumbotron-alttag" data-img-alttag="@if(isset($alttag))  {{ $alttag }} @endif">@if(isset($alttag) && trim($alttag) != "") {{ $alttag }} @else None  @endif</a>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('jumbotron', {
            menuText: '@lang('hilco::app.jumbotron')',
            bladeTemplate: 'hilco::components.jumbotron',
            init: function (body) {
                $(body).on('click', '#jumbotronThumbnail', function() {
                    var container = $(this).closest('.component-container');
                    assets.finder({
                        successFunction: function(data) {
                            var alt;
                            if(data.alttag != null && data.alttag != ""){
                                alt = data.alttag;
                            }else if(data.name != null && data.name != ""){
                                alt = data.name;
                            }else{
                                alt = 'None'
                            }

                            $(container).find('img#jumbotronThumbnail')
                                    .attr('src', data.url)
                                    .attr('alt', alt)
                                    .attr('data-web-asset-id', data.id)
                            ;

                            if(alt != 'None') {
                                $(container).find('.jumbotron-alttag').attr('data-img-alttag', alt);
                            }
                            $(container).find('.jumbotron-alttag').text(alt);
                        }
                    });
                }).on('click', '.jumbotron-alttag', function () {
                    var container = $(this).closest('.component-container');
                    var button = $(this);

                    assets.description({
                        successFunction: function (data) {
                            if(data.alttag != null && data.alttag != ""){
                                $(button).attr('data-img-alttag', data.alt);
                                $(button).text(data.alt);

                                $(container).find('img#jumbotronThumbnail')
                                    .attr('alt', data.alt)
                                ;
                            }

                        }
                    });
                });
            },
            serialize: function (componentNode) {
                return {
                    webAssetId: $(componentNode).find('img#jumbotronThumbnail').data('web-asset-id'),
                    alttag: $(componentNode).find('a.jumbotron-alttag').data('img-alttag'),
                }
            },
        });
    </script>
@endif

@if($view)
    <div class="row">
        <div
            @if(isset($full) && $full)
                class="col-xs-12"
            @else
                class="col-xs-8 col-xs-offset-2"
            @endif
        >
            <img style="width: 100%;" class="img-responsive" src="{{webAssetUrl($webAssetId)}}" alt="@if(isset($alttag))  {{ $alttag }} @endif">
        </div>
    </div>
    <br>
@endif
