<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Collection;
use Venturecraft\Revisionable\RevisionableTrait;

class WebGroup extends HierarchyModel implements HasLandingPageInterface {
	protected $table = "WebGroups";
	protected $fillable = ['name', 'slug', 'is_visible', 'detail'];
	protected $context_attributes = [];
	protected $context_table = 'WebContext_WebGroup';
	protected $context_foreign_key = 'webgroup_id';
	protected $casts = [
	    'is_visible' => 'boolean',
        'layout' => 'array',
	];
	
	public function webCategories() {
		return $this->belongsToMany(WebCategory::class, 'WebCategory_WebGroup', 'webgroup_id', 'webcategory_id');
	}

	public function featuredChildren() {
	    return $this->webCategories()->wherePivot('is_featured', 1);
    }

	public function getAssetPrefix() {
		return "webGroups/{$this->id}/webContexts";
	}

	public function scopeVisible(Builder $query) {
		return $query
			->where('is_visible', '1')
			->whereHas('webCategories', function ($query) {
				return $query->visible();
			})
		;
	}

    public function slugUrl() {
        return route('group.slug', [$this->slug]);
    }

    use HasSlug, HasLandingPage, RevisionableTrait;
}
