<?php

namespace Hilco\Models;

/**
 * Class WebSilo_AvailableLanguage
 * @package Hilco\Models
 * @property int $websilo_id
 * @property int $availablelanguage_id
 * @property bool $is_default
 * @property int $icon_override_id
 */
class WebSilo_AvailableLanguage extends WebModel {
    protected $table = 'WebSilo_AvailableLanguage';
    protected $fillable = ['websilo_id', 'availablelanguage_id', 'is_default', 'icon_override_id'];
    protected $casts = ['is_default' => 'boolean',];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function webSilo() {
        return $this->belongsTo(WebSilo::class, 'websilo_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function availableLanguage() {
        return $this->belongsTo(AvailableLanguage::class, 'availablelanguage_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function iconOverrideImage() {
        return $this->belongsTo(WebAsset::class, 'icon_override_id', 'id');
    }
}