<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WebRole extends WebModel {

	protected $table = 'WebRoles';
	protected $fillable = ['name', 'slug', 'description', 'is_enabled'];
    protected $with = ['webPermissions'];

    const CUSTOMER_ROLE_SLUG = 'web-user';

	public function webUsers()
	{
		return $this->belongsToMany(WebUser::class, 'WebRole_WebUser')->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
	}

	public function webPermissions()
	{
		return $this->belongsToMany(WebPermission::class, 'WebPermission_WebRole', 'webrole_id', 'webpermission_id')->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
	}

    public static function getCustomerRole() {
        return WebRole::where('slug', '=', self::CUSTOMER_ROLE_SLUG)->first();
    }

	public static function getDefault() {
	    return WebRole::where('slug', config('hilco.defaultWebRoleSlug', 'web-user'))->first();
    }
}