<?php
/**
 * Created by PhpStorm.
 * User: developer
 * Date: 8/15/16
 * Time: 12:42 PM
 */

namespace Hilco\Models;


class SalesOrderLineSchedule extends WebModel
{
    protected $table = 'SalesOrderLineSchedules';

    public static $statuses = [
        "CANCELED",
        "OPEN",
        "PAID",
    ];


    public function order()
    {
        return $this->belongsTo(Order::class, 'salesorder_id');
    }

    public function shipment() {
        return $this->belongsTo(Shipment::class, 'shipment_id');
    }

    public function orderMainLine()
    {
        return $this->belongsTo(OrderMainLine::class, 'salesordermainline_id');
    }

    public function scopeWithStatus($query, $status=[], $method="in"){
        $whereStatuses = array_intersect(self::$statuses,$status);
        if($method=="in") return $query->whereIn('schedule_status',$whereStatuses);
        elseif($method=="notIn") return $query->whereNotIn('schedule_status',$whereStatuses);
        else return $query;
    }
}