<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property integer $id
 * @property integer $promotion_id
 * @property integer $subscriptiongroup_id
 * @property bool $applied
 */
class Promotion_SubscriptionGroup extends WebModel {
    protected $table = "Promotion_SubscriptionGroup";
    protected $fillable = ["promotion_id", "subscriptiongroup_id", "applied", "commit_sequence"];

    /**
     * @return BelongsTo
     */
    public function promotion(): BelongsTo {
        return $this->belongsTo(Promotion::class, "promotion_id", "id");
    }

    /**
     * @return BelongsTo
     */
    public function subscriptionGroup(): BelongsTo {
        return $this->belongsTo(SubscriptionGroup::class, "subscriptiongroup_id", "id");
    }

    public function isApplied(): bool {
        return $this->applied == 1;
    }
}