<?php

namespace Hilco\Models;

use DB;
use Illuminate\Database\Eloquent\Collection;

/**
 * Model Class PromotionWebSiloTrigger
 * @property Collection $promotionWebSiloTriggerWebSilos
 * @property Collection $webSilos
 */
class PromotionWebSiloTrigger extends PromotionTriggerDetails {
    protected $table = "PromotionWebSiloTriggers";

    public function promotionWebSiloTriggerWebSilos() {
        return $this->hasMany(PromotionWebSiloTrigger_WebSilo::class, 'promotionwebsilotrigger_id', 'id');
    }

    public function webSilos() {
        return $this->belongsToMany(
            WebSilo::class, 'PromotionWebSiloTrigger_WebSilo', 'promotionwebsilotrigger_id', 'websilo_id'
        )->wherePivot('deleted_at', '=', DB::raw(0));
    }

    public function isTriggered (Customer $soldToCustomer, $webCartItems, $distinctPartInfo = []) {
        $activeWebSilo = $soldToCustomer->webSilo;
        return $this->webSilos->where('id', '=', $activeWebSilo->id)->count() > 0;
    }

    public function postTriggerOperation($soldToCustomer){}
}